﻿/*
Run this script to update the MET/CONNECT database from 3.7.0 to 3.8.0

You are recommended to back up your database before running this script

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF EXISTS (SELECT * FROM tempdb..sysobjects WHERE id=OBJECT_ID('tempdb..#tmpErrors')) DROP TABLE #tmpErrors
GO
CREATE TABLE #tmpErrors (Error int)
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.7.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.7.0 is missing. ***', 20,-1) WITH LOG
END
GO

-- set database compatibility level to SQL Server 2012
DECLARE @comp NVARCHAR(max);
SET @comp = N'ALTER DATABASE [' + (SELECT DB_NAME()) + ']
SET COMPATIBILITY_LEVEL = 110 '
EXEC sp_executesql @comp
GO

-- temporary - remove before release!
DELETE FROM [dbo].[Version] WHERE nVersionUID = 'FAF705A1-227B-4BBE-BE85-E1FAA44B3832'
GO

-- No need to process if we have a 3.8.0 version record
IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE nVersionUID = 'FAF705A1-227B-4BBE-BE85-E1FAA44B3832')
BEGIN
	BEGIN TRANSACTION

	-- get the current collation and switch it to case-sensitive
	DECLARE @sql NVARCHAR(max);
	DECLARE @coll_cs NVARCHAR(100);
	SELECT @coll_cs = collation_name FROM sys.databases WHERE name = (SELECT DB_NAME());
	SELECT @coll_cs = REPLACE(@coll_cs, N'CI', N'CS');


	-->> MTM-12683 <<--
	IF EXISTS ( SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '94FB20AA-198B-4E76-9DB3-255F41B288B5' )
	BEGIN
		PRINT N'Updating database to remove duplicate UCIData record for Types field cDimension'
		IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nUCIDataUID = '94FB20AA-198B-4E76-9DB3-255F41B288B5' )
		BEGIN
			PRINT N'Changing ContextElement records to reference original UCIData record for Types field cDimension'
			UPDATE [dbo].[ContextElements] SET nUCIDataUID = 'BB87BCDB-95A7-4B39-954A-1C0636201676', tUpdateTime = GETUTCDATE() WHERE nUCIDataUID = '94FB20AA-198B-4E76-9DB3-255F41B288B5'

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF EXISTS ( SELECT * FROM [dbo].[AvailableConfigTableColumns] WHERE nUCIDataUID = '94FB20AA-198B-4E76-9DB3-255F41B288B5' )
		BEGIN
			PRINT N'Changing AvailableConfigTableColumns records to reference original UCIData record for Types field cDimension'
			UPDATE [dbo].[AvailableConfigTableColumns] SET nUCIDataUID = 'BB87BCDB-95A7-4B39-954A-1C0636201676', tUpdateTime = GETUTCDATE() WHERE nUCIDataUID = '94FB20AA-198B-4E76-9DB3-255F41B288B5' 

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF EXISTS ( SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE nUCIDataUID = '94FB20AA-198B-4E76-9DB3-255F41B288B5' )
		BEGIN
			PRINT N'Changing SecurityGroupFieldLinks records to reference original UCIData record for Types field cDimension'
			UPDATE [dbo].[SecurityGroupFieldLinks] SET nUCIDataUID = 'BB87BCDB-95A7-4B39-954A-1C0636201676', tUpdateTime = GETUTCDATE() WHERE nUCIDataUID = '94FB20AA-198B-4E76-9DB3-255F41B288B5' 

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		PRINT N'Deleting duplicate UCIData record for Types field cDimension'
		DELETE FROM [dbo].[UCIData] WHERE nUCIDataUID = '94FB20AA-198B-4E76-9DB3-255F41B288B5'

		IF EXISTS ( SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'BB87BCDB-95A7-4B39-954A-1C0636201676' )
		BEGIN
			PRINT N'Activating original UCIData record for Types field cDimension'
			UPDATE [dbo].[UCIData] SET lDeleted = 0, lActive = -1, tUpdateTime = GETUTCDATE() WHERE nUCIDataUID = 'BB87BCDB-95A7-4B39-954A-1C0636201676'

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END

	IF EXISTS ( SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'F1BD5D98-5B25-47DE-A7E6-52BED7DF377D' )
	BEGIN
		PRINT N'Updating database to remove duplicate UCIData record for Procedures field nProcedureFileUID'
		IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nUCIDataUID = 'F1BD5D98-5B25-47DE-A7E6-52BED7DF377D' )
		BEGIN
			PRINT N'Changing ContextElement records to reference original UCIData record for Procedures field nProcedureFileUID'
			UPDATE [dbo].[ContextElements] SET nUCIDataUID = 'E1533B1D-756C-4825-8E20-73B05A82A0AE', tUpdateTime = GETUTCDATE() WHERE nUCIDataUID = 'F1BD5D98-5B25-47DE-A7E6-52BED7DF377D'

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF EXISTS ( SELECT * FROM [dbo].[AvailableConfigTableColumns] WHERE nUCIDataUID = 'F1BD5D98-5B25-47DE-A7E6-52BED7DF377D' )
		BEGIN
			PRINT N'Changing AvailableConfigTableColumns records to reference original UCIData record for Procedures field nProcedureFileUID'
			UPDATE [dbo].[AvailableConfigTableColumns] SET nUCIDataUID = 'E1533B1D-756C-4825-8E20-73B05A82A0AE', tUpdateTime = GETUTCDATE() WHERE nUCIDataUID = 'F1BD5D98-5B25-47DE-A7E6-52BED7DF377D' 

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF EXISTS ( SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE nUCIDataUID = 'F1BD5D98-5B25-47DE-A7E6-52BED7DF377D' )
		BEGIN
			PRINT N'Changing SecurityGroupFieldLinks records to reference original UCIData record for Procedures field nProcedureFileUID'
			UPDATE [dbo].[SecurityGroupFieldLinks] SET nUCIDataUID = 'E1533B1D-756C-4825-8E20-73B05A82A0AE', tUpdateTime = GETUTCDATE() WHERE nUCIDataUID = 'F1BD5D98-5B25-47DE-A7E6-52BED7DF377D' 

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		PRINT N'Deleting duplicate UCIData record for Procedures field nProcedureFileUID'
		DELETE FROM [dbo].[UCIData] WHERE nUCIDataUID = 'F1BD5D98-5B25-47DE-A7E6-52BED7DF377D'

		IF EXISTS ( SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'E1533B1D-756C-4825-8E20-73B05A82A0AE' )
		BEGIN
			PRINT N'Activating original UCIData record for Procedures field nProcedureFileUID'
			UPDATE [dbo].[UCIData] SET lDeleted = 0, lActive = -1, tUpdateTime = GETUTCDATE() WHERE nUCIDataUID = 'E1533B1D-756C-4825-8E20-73B05A82A0AE'

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END


	-->>MTM-12752<<--
	SELECT @sql = N'
	IF EXISTS(SELECT * FROM [dbo].[QuickNotes] WHERE [cControl] LIKE ''lbl_%'')
	BEGIN
		PRINT ''Updating QuickNotes''
		UPDATE
			[dbo].[QuickNotes] 
		SET
			[cControl] = REPLACE(cControl, ''lbl_'', '''')
		WHERE
			[cControl] LIKE ''lbl_%''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END
	
	-->>METCON-3484<<--
	IF EXISTS(SELECT * from [dbo].[LicenseDetails])
	BEGIN
		PRINT N'Removing All LicenseDetails Records'
		DELETE FROM [dbo].[LicenseDetails]
	END


	-->>METCON-3430<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = N'837B072A-707E-453C-8781-F53551E95C25')
	BEGIN
		PRINT N'Adding UCIData record: 837B072A-707E-453C-8781-F53551E95C25'

		INSERT INTO [dbo].[UCIData] ([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES (N'837B072A-707E-453C-8781-F53551E95C25', N'MET/CAL', N'Temperature and Humidity Settings', N'Enabled', N'1', -1, 0, 0, 0, N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20240301 23:46:27.403', N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20240301 23:46:27.403', N'20240301 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE nSecurityGroupFieldLinkUID = N'6047D77B-D20E-4579-9642-671F56A98A3B')
	BEGIN
		PRINT N'Adding SecurityGroupFieldLinks record: 6047D77B-D20E-4579-9642-671F56A98A3B'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES (N'6047D77B-D20E-4579-9642-671F56A98A3B', N'FD8E1F20-3E2F-4C7D-8D24-965F18A5A3E0', N'837B072A-707E-453C-8781-F53551E95C25', -1, 0, 0, 0, N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20210317 23:46:27.403', N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20210317 23:46:27.403', N'20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE nSecurityGroupFieldLinkUID = N'D22C1C24-627A-4BD7-A167-377310BBDBE7')
	BEGIN
		PRINT N'Adding SecurityGroupFieldLinks record: D22C1C24-627A-4BD7-A167-377310BBDBE7'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES (N'D22C1C24-627A-4BD7-A167-377310BBDBE7', N'9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', N'837B072A-707E-453C-8781-F53551E95C25', -1, 0, 0, 0, N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20210317 23:46:27.403', N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20210317 23:46:27.403', N'20210317 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	-->>MC-15274<<--
	-->> Add the Edit Results Security Permission <<--
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = N'22F87904-EF31-4A8C-A220-0CC0B167902A'  )
	BEGIN
		PRINT N'Adding UCIData record for Edit Results (UID: 22F87904-EF31-4A8C-A220-0CC0B167902A)'

		INSERT INTO [dbo].[UCIData] ([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES (N'22F87904-EF31-4A8C-A220-0CC0B167902A', N'MET/CAL', N'Edit Results', N'Enabled', N'1', -1, 0, 0, 0, N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20240922 23:46:27.403', N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20240922 23:46:27.403', N'20240922 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	-->> add the Edit Results permission to the Metrologist Group <<--
	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE nSecurityGroupFieldLinkUID = N'4247DD6F-EFF5-43F2-A976-40053DABDF09')
	BEGIN
		PRINT N'Adding SecurityGroupFieldLinks record: 4247DD6F-EFF5-43F2-A976-40053DABDF09'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES (N'4247DD6F-EFF5-43F2-A976-40053DABDF09', N'9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', N'22F87904-EF31-4A8C-A220-0CC0B167902A', -1, 0, 0, 0, N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20210529 23:46:27.403', N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20210529 23:46:27.403', N'20210529 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	
	-->>METCON-3571<<--
	-->> Add the Results View Security Permission <<--
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = N'F7EFA31C-ED2F-40F3-9077-4688A3187EB4'  )
	BEGIN
		PRINT N'Adding UCIData record for Results View Tab (UID: F7EFA31C-ED2F-40F3-9077-4688A3187EB4)'

		INSERT INTO [dbo].[UCIData] ([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES (N'F7EFA31C-ED2F-40F3-9077-4688A3187EB4', N'MET/CAL', N'Results View', N'Enabled', N'1', -1, 0, 0, 0, N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20240529 23:46:27.403', N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20240529 23:46:27.403', N'20240529 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	-->> add the Results View permission to the Administrator group <<--
	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE nSecurityGroupFieldLinkUID = N'00F82AE7-C139-4117-97F1-14B537A9D336')
	BEGIN
		PRINT N'Adding SecurityGroupFieldLinks record: 00F82AE7-C139-4117-97F1-14B537A9D336'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES (N'00F82AE7-C139-4117-97F1-14B537A9D336', N'FD8E1F20-3E2F-4C7D-8D24-965F18A5A3E0', N'F7EFA31C-ED2F-40F3-9077-4688A3187EB4', -1, 0, 0, 0, N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20210529 23:46:27.403', N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20210529 23:46:27.403', N'20210529 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	-->> add the Results View permission to the Metrologist Group <<--
	IF NOT EXISTS(SELECT * FROM [dbo].[SecurityGroupFieldLinks] WHERE nSecurityGroupFieldLinkUID = N'22B703F9-31B5-4DA6-ABCC-3A54B3DA5F95')
	BEGIN
		PRINT N'Adding SecurityGroupFieldLinks record: 22B703F9-31B5-4DA6-ABCC-3A54B3DA5F95'

		INSERT INTO [dbo].[SecurityGroupFieldLinks] ([nSecurityGroupFieldLinkUID], [nSecurityGroupUID], [nUCIDataUID], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES (N'22B703F9-31B5-4DA6-ABCC-3A54B3DA5F95', N'9C6A595B-5DA1-4D1E-8FFD-142902AAEAFC', N'F7EFA31C-ED2F-40F3-9077-4688A3187EB4', -1, 0, 0, 0, N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20210529 23:46:27.403', N'DBA97ADF-F868-459D-8343-DE1DF0FFB398', N'915F9722-3175-4E4D-A571-4A478E8E5172', N'20210529 23:46:27.403', N'20210529 23:46:27.403', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>METCON-3194<<--
	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUIDs]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUIDs]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUIDs]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUIDs]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUIDs]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUIDs]
AS
BEGIN
	SELECT
		[nCallSheetResultStandardLinkUID]
	FROM
		[dbo].[CallSheetResultStandardLink]

	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUpdated]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUpdated]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUpdated]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUpdated]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUpdated]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResultStandardLink_GetAllUpdated]
	@startDate datetime
	,@count int
AS
BEGIN
	SELECT TOP (@count)
		[nCallSheetResultStandardLinkUID]
		,[nCallSheetResultUID]
		,[nCallSheetStandardLinkUID]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]
		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	FROM
		[dbo].[CallSheetResultStandardLink]
	WHERE
		[tUpdateTime] >= @startDate
	ORDER BY
		[tUpdateTime] ASC
	RETURN
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultStandardLink_Insert]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResultStandardLink_Insert]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResultStandardLink_Insert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultStandardLink_Insert]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResultStandardLink_Insert]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResultStandardLink_Insert]
	@nCallSheetResultStandardLinkUID uniqueidentifier
	,@nCallSheetResultUID uniqueidentifier  = NULL
	,@nCallSheetStandardLinkUID uniqueidentifier  = NULL

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	INSERT INTO [dbo].[CallSheetResultStandardLink] (
		[nCallSheetResultStandardLinkUID]
		,[nCallSheetResultUID]
		,[nCallSheetStandardLinkUID]

		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@nCallSheetResultStandardLinkUID
		,@nCallSheetResultUID
		,@nCallSheetStandardLinkUID

		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@tAddTime
		,@nUpdateFacilityUID
		,@nUpdateUserUID
		,@tUpdateTime
		,@tMobileTime
	)
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultStandardLink_Update]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Mobile_CallSheetResultStandardLink_Update]'
		DROP PROCEDURE [dbo].[spl_Mobile_CallSheetResultStandardLink_Update]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Mobile_CallSheetResultStandardLink_Update]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Mobile_CallSheetResultStandardLink_Update]'

		EXEC sp_executesql N'
CREATE PROCEDURE [dbo].[spl_Mobile_CallSheetResultStandardLink_Update]
	@nCallSheetResultStandardLinkUID uniqueidentifier
	,@nCallSheetResultUID uniqueidentifier
	,@nCallSheetStandardLinkUID uniqueidentifier

	,@lActive int  = -1
	,@lDeleted int  = 0
	,@lApproved int  = 0
	,@lAdded int  = -1
	,@nAddFacilityUID uniqueidentifier
	,@nAddUserUID uniqueidentifier
	,@tAddTime datetime
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@tUpdateTime datetime
	,@tMobileTime datetime
AS
BEGIN
	UPDATE [dbo].[CallSheetResultStandardLink]
	SET
		[nCallSheetResultUID] = @nCallSheetResultUID
		,[nCallSheetStandardLinkUID] = @nCallSheetStandardLinkUID

		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nAddFacilityUID] = @nAddFacilityUID
		,[nAddUserUID] = @nAddUserUID
		,[tAddTime] = @tAddTime
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[tUpdateTime] = @tUpdateTime
		,[tMobileTime] = @tMobileTime
	WHERE
		[nCallSheetResultStandardLinkUID] = @nCallSheetResultStandardLinkUID
	RETURN 1
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->> METCON-3582, METCON-3613 <<--
	IF OBJECT_ID(N'[dbo].[GetWorkOrderSummary]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[GetWorkOrderSummary]'
		DROP PROCEDURE [dbo].GetWorkOrderSummary

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[GetWorkOrderSummary]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[GetWorkOrderSummary]'

		EXEC sp_executesql N'
/****************************************************************
	GetWorkOrderSummary

	Gets summary information for a work order and asset. The Work Order Number
	or Asset Number can be blank but not both

	(c) 2024 Fluke Calibration
-----------------------------------------------------------------
	(KW) 06/13/2024		Initial Version
	(KW) 07/30/2024		Added cWorkOrderResultPassFail & cWorkOrderResultSection
	(KW) 09/18/2024		Changed to use the CallSheetsResults procedure instead of CallSheets procedure
*****************************************************************/

CREATE PROCEDURE [dbo].[GetWorkOrderSummary]

@barcode NVARCHAR(100),
@wonumber NVARCHAR(50)


AS
BEGIN

	SET @barcode = NULLIF(@barcode, '''')
	SET @wonumber = NULLIF(@wonumber, '''')

	IF @barcode IS NOT NULL OR @wonumber IS NOT NULL
	BEGIN
		SELECT
			csrex.[cField050] AS [cResultGroupId],
			woex.[nAssetUID] AS [nAssetUID],
			woex.[nCallSheetUID] AS [nWorkOrderUID],
			woex.[cAssetBarcode] AS [cAssetNumber],
			woex.[cCallSheetNumber] AS [cWorkOrderNumber],
			p.[cProcedureName],
			csrex.[cField049] AS [cProcedureSectionOrdinal],
			csr.[tStartTime] As [tWorkOrderResultDateTime],
			csr.[cDescription] AS [cWorkOrderResultSection],
			csr.[cStatus] AS [cWorkOrderResultPassFail],
			csr.nCallSheetResultUID AS [nWorkOrderResultUID]
		FROM [dbo].[vw_WorkOrdersWithEx] woex 
		LEFT JOIN [dbo].[CallSheetResults] csr ON woex.nCallSheetUID = csr.nCallSheetUID
		LEFT JOIN [dbo].[CallSheetResultEx] csrex ON csr.nCallSheetResultUID = csrex.nCallSheetResultUID
		LEFT JOIN [dbo].[Procedures] p ON csr.nProcedureUID = p.nProcedureUID
		WHERE woex.lActive <> 0 AND csr.lActive <> 0 AND csrex.lActive <> 0
		AND woex.lDeleted = 0 AND csr.lDeleted = 0 AND csrex.lDeleted = 0
		AND (woex.[cAssetBarcode] = @barcode OR @barcode IS NULL) 
		AND (woex.[cCallSheetNumber] = @wonumber OR @wonumber IS NULL)
		ORDER BY csr.[tStartTime], csrex.[cField049]
	END
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MC-15264<<--
	IF OBJECT_ID(N'[dbo].[udf_GetPointReadingsCount]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetPointReadingsCount]'
		DROP FUNCTION [dbo].[udf_GetPointReadingsCount]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[udf_GetPointReadingsCount]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetPointReadingsCount]'

		EXEC sp_executesql N'
/************************************************************************************************
    udf_GetPointReadingsCount
    
    Gets the count of indvidual measurements (readings) that were averaged
    when the parent Points record was created

    Parameters:
    @nPointUID - UID for the Points record

    (C) 2014-24 Fluke Calibration
-----------------------------------------------------------------
    CHANGE HISTORY
    09/19/2024  AC    Initially created
    
*************************************************************************************************/

CREATE FUNCTION [dbo].[udf_GetPointReadingsCount] ( @nPointUID [UNIQUEIDENTIFIER] )
RETURNS TABLE
AS
RETURN
(
	SELECT 
		COUNT(nPointReadingUID) AS count
	FROM
		PointReadings
	WHERE
		nPointUID = @nPointUID
	AND
		lDeleted = 0 AND lActive <> 0
);
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>Make sure views are up to date - keep this in the last spot on the script<<--
	IF OBJECT_ID(N'[dbo].[AuditHistory]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[AuditHistory]'
	IF OBJECT_ID(N'[dbo].[AuditHistory2]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[AuditHistory2]';
	IF OBJECT_ID(N'[dbo].[Ver_8_Config_Vw]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[Ver_8_Config_Vw]';
	IF OBJECT_ID(N'[dbo].[Ver_8_Stds_Vw]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[Ver_8_Stds_Vw]';
	IF OBJECT_ID(N'[dbo].[vw_AlertingEventsCurrentlyDue]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AlertingEventsCurrentlyDue]';
	IF OBJECT_ID(N'[dbo].[vw_AllAssets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AllAssets]';
	IF OBJECT_ID(N'[dbo].[vw_AllCallsheets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AllCallsheets]';
	IF OBJECT_ID(N'[dbo].[vw_AllCallsheetStandards]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AllCallsheetStandards]';
	IF OBJECT_ID(N'[dbo].[vw_AllParts]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AllParts]';
	IF OBJECT_ID(N'[dbo].[vw_AllReadings]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AllReadings]';
	IF OBJECT_ID(N'[dbo].[vw_APITokens]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_APITokens]';
	IF OBJECT_ID(N'[dbo].[vw_Assets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Assets]';
	IF OBJECT_ID(N'[dbo].[vw_AssetsWithCallSheets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AssetsWithCallSheets]';
	IF OBJECT_ID(N'[dbo].[vw_AssetsWithEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AssetsWithEx]';
	IF OBJECT_ID(N'[dbo].[vw_AssetsWithServices]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AssetsWithServices]';
	IF OBJECT_ID(N'[dbo].[vw_AssetWithOpenCallsheets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AssetWithOpenCallsheets]';
	IF OBJECT_ID(N'[dbo].[vw_AuditDetail]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_AuditDetail]';
	IF OBJECT_ID(N'[dbo].[vw_BillingReport]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_BillingReport]';
	IF OBJECT_ID(N'[dbo].[vw_CallSheetLog]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_CallSheetLog]';
	IF OBJECT_ID(N'[dbo].[vw_CallSheetReadings]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_CallSheetReadings]';
	IF OBJECT_ID(N'[dbo].[vw_CallSheetResultEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_CallSheetResultEx]';
	IF OBJECT_ID(N'[dbo].[vw_CallSheets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_CallSheets]';
	IF OBJECT_ID(N'[dbo].[vw_CallSheetsWithAttCheck]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_CallSheetsWithAttCheck]';
	IF OBJECT_ID(N'[dbo].[vw_ConfigTableColumns]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ConfigTableColumns]';
	IF OBJECT_ID(N'[dbo].[vw_DataToolConflictWIP]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_DataToolConflictWIP]';
	IF OBJECT_ID(N'[dbo].[vw_DataToolDelWIP]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_DataToolDelWIP]';
	IF OBJECT_ID(N'[dbo].[vw_DataToolDupsWIP]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_DataToolDupsWIP]';
	IF OBJECT_ID(N'[dbo].[vw_DataToolDupsWIPCounts]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_DataToolDupsWIPCounts]';
	IF OBJECT_ID(N'[dbo].[vw_DataToolDupsWIPLabels]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_DataToolDupsWIPLabels]';
	IF OBJECT_ID(N'[dbo].[vw_EMXAuditDetail]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_EMXAuditDetail]';
	IF OBJECT_ID(N'[dbo].[vw_EMXAuditHeader]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_EMXAuditHeader]';
	IF OBJECT_ID(N'[dbo].[vw_EstimateItems]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_EstimateItems]';
	IF OBJECT_ID(N'[dbo].[vw_Estimates]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Estimates]';
	IF OBJECT_ID(N'[dbo].[vw_ExtendedDataDetails]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ExtendedDataDetails]';
	IF OBJECT_ID(N'[dbo].[vw_Facilities]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Facilities]';
	IF OBJECT_ID(N'[dbo].[vw_FileMd5]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_FileMd5]';
	IF OBJECT_ID(N'[dbo].[vw_Inventory_w_CS_IntervalsReport]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Inventory_w_CS_IntervalsReport]';
	IF OBJECT_ID(N'[dbo].[vw_JobNumberFacilities]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_JobNumberFacilities]';
	IF OBJECT_ID(N'[dbo].[vw_JobNumbers]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_JobNumbers]';
	IF OBJECT_ID(N'[dbo].[vw_LabMetricsTimeSpent]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_LabMetricsTimeSpent]';
	IF OBJECT_ID(N'[dbo].[vw_LabMetricsTurnTimes]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_LabMetricsTurnTimes]';
	IF OBJECT_ID(N'[dbo].[vw_LabMetricsTurnTimesWithBreakdown]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_LabMetricsTurnTimesWithBreakdown]';
	IF OBJECT_ID(N'[dbo].[vw_ManualTemplateInfo]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ManualTemplateInfo]';
	IF OBJECT_ID(N'[dbo].[vw_METCAL_DataPoints]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_METCAL_DataPoints]';
	IF OBJECT_ID(N'[dbo].[vw_MobileSettings]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_MobileSettings]';
	IF OBJECT_ID(N'[dbo].[vw_OpenCallSheets]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_OpenCallSheets]';
	IF OBJECT_ID(N'[dbo].[vw_PackageHistory]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PackageHistory]';
	IF OBJECT_ID(N'[dbo].[vw_Parts]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Parts]';
	IF OBJECT_ID(N'[dbo].[vw_PartWithEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PartWithEx]';
	IF OBJECT_ID(N'[dbo].[vw_PointExNumerics]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PointExNumerics]';
	IF OBJECT_ID(N'[dbo].[vw_PointReadings]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PointReadings]';
	IF OBJECT_ID(N'[dbo].[vw_Points]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Points]';
	IF OBJECT_ID(N'[dbo].[vw_PointStatistics]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PointStatistics]';
	IF OBJECT_ID(N'[dbo].[vw_PointTolerances]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PointTolerances]';
	IF OBJECT_ID(N'[dbo].[vw_PointUncertainties]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_PointUncertainties]';
	IF OBJECT_ID(N'[dbo].[vw_ProblemReports]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ProblemReports]';
	IF OBJECT_ID(N'[dbo].[vw_ProblemReportsWithEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ProblemReportsWithEx]';
	IF OBJECT_ID(N'[dbo].[vw_Procedures]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Procedures]';
	IF OBJECT_ID(N'[dbo].[vw_ProceduresWithEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ProceduresWithEx]';
	IF OBJECT_ID(N'[dbo].[vw_ProcedureStandards]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ProcedureStandards]';
	IF OBJECT_ID(N'[dbo].[vw_Prompts]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Prompts]';
	IF OBJECT_ID(N'[dbo].[vw_ServiceTypes1]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ServiceTypes1]';
	IF OBJECT_ID(N'[dbo].[vw_ShipmentItems]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ShipmentItems]';
	IF OBJECT_ID(N'[dbo].[vw_Shipments]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Shipments]';
	IF OBJECT_ID(N'[dbo].[vw_SmtpSettings]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_SmtpSettings]';
	IF OBJECT_ID(N'[dbo].[vw_ToolAssignments]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ToolAssignments]';
	IF OBJECT_ID(N'[dbo].[vw_ToolAssignmentsWithEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_ToolAssignmentsWithEx]';
	IF OBJECT_ID(N'[dbo].[vw_Types]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_Types]';
	IF OBJECT_ID(N'[dbo].[vw_TypesWithEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_TypesWithEx]';
	IF OBJECT_ID(N'[dbo].[vw_UnbilledLabor]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_UnbilledLabor]';
	IF OBJECT_ID(N'[dbo].[vw_WorkOrdersWithEx]', 'V') IS NOT NULL EXEC sp_refreshview N'[dbo].[vw_WorkOrdersWithEx]';

    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	PRINT N'Updating database version'
	INSERT INTO [dbo].[Version] (
		[nVersionUID]
		,[cVersion]
		,[tInstallDate]
		,[mNote]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
	  )
	  VALUES
	  (
		'FAF705A1-227B-4BBE-BE85-E1FAA44B3832'
		,'3.8.0'
		,'20240213 20:27:26.863'
		,'3.8.0 Release'
		,-1
		,0
		,0
		,0
		,'DBA97ADF-F868-459D-8343-DE1DF0FFB398'
		,'915F9722-3175-4E4D-A571-4A478E8E5172'
		,'20240213 20:27:26.863'
		,'DBA97ADF-F868-459D-8343-DE1DF0FFB398'
		,'915F9722-3175-4E4D-A571-4A478E8E5172'
		,'20240213 20:27:26.863'
		,'20240213 20:27:26.863'
		,NULL
	  )

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	-- Make sure previous version records are inactive
	UPDATE [dbo].[Version] SET lActive = 0, tUpdateTime = '20240213 20:27:26.863', tMobileTime = '20240213 20:27:26.863' WHERE lActive <> 0 AND nVersionUID <> 'FAF705A1-227B-4BBE-BE85-E1FAA44B3832'

	IF EXISTS (SELECT * FROM #tmpErrors) ROLLBACK TRANSACTION

	IF @@TRANCOUNT>0 BEGIN
	PRINT 'The database update succeeded'
	COMMIT TRANSACTION
	END
	ELSE PRINT 'The database update failed'

	DROP TABLE #tmpErrors
END
ELSE
	Print N'The database is up-to-date, version 3.8.0'
GO
